/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.MaterialRequest;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.util.Localizer;

public class SupplyRequest
extends MaterialRequest {
    private State state;

    public SupplyRequest(String id, Material material, long time, double qty) {
        this(id, material, time, qty, State.PROPOSED);
    }

    public SupplyRequest(String id, Material material, long time, double qty, State state) {
        super(id, time, material, qty);
        Preconditions.checkArgument(qty > 0.0, "Quantity of SupplyRequset must be positive.");
        this.state = state;
        this.storeAct.setType(SupplyRequest.getStoreType(state));
    }

    @Override
    public double getQty() {
        return this.getStoreActivity().getQty();
    }

    @Override
    public void setQty(double qty) {
        Preconditions.checkArgument(qty > 0.0, "Quantity of CustomerRequset must be positive.");
        this.setSaQty(qty);
    }

    public String toString() {
        return "SupplyRequest(" + this.getId() + ", " + this.getMaterial().getName() + ", " + this.getTime() + ", " + this.getQty() + ")";
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        Preconditions.checkNotNull(state);
        Plan plan = this.storeAct.getPlan();
        this.removeSaFromPlan();
        this.storeAct.setType(SupplyRequest.getStoreType(state));
        this.state = state;
        this.addSaToPlan(plan);
    }

    private static StoreType getStoreType(State state) {
        switch (state) {
            case PROPOSED: 
            case CONFIRMED: 
            case CANCEL_PROPOSAL: 
            case VIRTUAL: {
                return StoreType.INPLAN_ACTUAL;
            }
            case INACTIVE: {
                return StoreType.INPLAN_POSSIBLE;
            }
        }
        throw new IllegalStateException();
    }

    public static enum State {
        PROPOSED,
        CONFIRMED,
        CANCEL_PROPOSAL,
        VIRTUAL,
        INACTIVE;


        public String toString() {
            switch (this) {
                case PROPOSED: {
                    return Localizer.getString("supply_request.state.proposed");
                }
                case CONFIRMED: {
                    return Localizer.getString("supply_request.state.confirmed");
                }
                case CANCEL_PROPOSAL: {
                    return Localizer.getString("supply_request.state.cancel_proposal");
                }
                case VIRTUAL: {
                    return Localizer.getString("supply_request.state.virtual");
                }
                case INACTIVE: {
                    return Localizer.getString("supply_request.state.inactive");
                }
            }
            throw new IllegalStateException();
        }
    }
}

